/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class BukkitTools {
    private static Towny plugin = null;
    private static Server server = null;

    public static void initialize(Towny plugin) {
        BukkitTools.plugin = plugin;
        server = plugin.getServer();
    }

    public static Player[] getOnlinePlayers() {
        return BukkitTools.getServer().getOnlinePlayers();
    }

    public static List<Player> matchPlayer(String name) {
        return BukkitTools.getServer().matchPlayer(name);
    }

    public static Player getPlayerExact(String name) {
        return BukkitTools.getServer().getPlayerExact(name);
    }

    public static boolean isOnline(String playerName) {
        return BukkitTools.getServer().getPlayer(playerName) != null;
    }

    public static List<World> getWorlds() {
        return server.getWorlds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getServer() {
        Server server = BukkitTools.server;
        synchronized (server) {
            return BukkitTools.server;
        }
    }

    public static BukkitScheduler getScheduler() {
        return BukkitTools.getServer().getScheduler();
    }

    public static int scheduleSyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, task, delay);
    }

    public static int scheduleAsyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().scheduleAsyncDelayedTask((Plugin)plugin, task, delay);
    }

    public static int scheduleSyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, task, delay, repeat);
    }

    public static int scheduleAsyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().scheduleAsyncRepeatingTask((Plugin)plugin, task, delay, repeat);
    }

    public static HashMap<String, Integer> getPlayersPerWorld() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (World world : BukkitTools.getServer().getWorlds()) {
            m.put(world.getName(), 0);
        }
        Player[] playerArray = BukkitTools.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            m.put(player.getWorld().getName(), m.get(player.getWorld().getName()) + 1);
            ++n2;
        }
        return m;
    }

    public static Block getBlockOffset(Block block, int xOffset, int yOffset, int zOffset) {
        return block.getWorld().getBlockAt(block.getX() + xOffset, block.getY() + yOffset, block.getZ() + zOffset);
    }

    public static List<String> getWhiteListedUsers() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            BufferedReader fin = new BufferedReader(new FileReader("white-list.txt"));
            try {
                String line;
                while ((line = fin.readLine()) != null) {
                    names.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                fin.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return names;
    }

    public static int calcChunk(int value) {
        return value * TownySettings.getTownBlockSize() / 16;
    }
}

