/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChatTools {
    public static final int lineLength = 54;

    public static List<String> listArr(String[] args) {
        return ChatTools.list(Arrays.asList(args));
    }

    public static List<String> listArr(String[] args, String prefix) {
        return ChatTools.list(Arrays.asList(args), prefix);
    }

    public static List<String> list(List<String> args) {
        return ChatTools.list(args, "");
    }

    public static List<String> list(List<String> args, String prefix) {
        if (args.size() > 0) {
            String line = "";
            int i = 0;
            while (i < args.size() - 1) {
                line = String.valueOf(line) + args.get(i) + ", ";
                ++i;
            }
            line = String.valueOf(line) + args.get(args.size() - 1).toString();
            return ChatTools.color(String.valueOf(prefix) + line);
        }
        return new ArrayList<String>();
    }

    public static List<String> wordWrap(String[] tokens) {
        ArrayList<String> out = new ArrayList<String>();
        out.add("");
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (ChatTools.stripColour((String)out.get(out.size() - 1)).length() + ChatTools.stripColour(s).length() + 1 > 54) {
                out.add("");
            }
            out.set(out.size() - 1, String.valueOf((String)out.get(out.size() - 1)) + s + " ");
            ++n2;
        }
        return out;
    }

    public static List<String> color(String line) {
        List<String> out = ChatTools.wordWrap(line.split(" "));
        String c = "f";
        int i = 0;
        while (i < out.size()) {
            if (!out.get(i).startsWith("\u00a7") && !c.equalsIgnoreCase("f")) {
                out.set(i, "\u00a7" + c + out.get(i));
            }
            int index = 0;
            while (index < 54) {
                try {
                    if (out.get(i).substring(index, index + 1).equalsIgnoreCase("\u00a7")) {
                        c = out.get(i).substring(index + 1, index + 2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++index;
            }
            ++i;
        }
        return out;
    }

    public static String parseSingleLineString(String str) {
        return str.replaceAll("&", "\u00a7");
    }

    public static String stripColour(String s) {
        String out = "";
        int i = 0;
        while (i < s.length()) {
            String c = s.substring(i, i + 1);
            if (c.equals("\u00a7")) {
                ++i;
            } else {
                out = String.valueOf(out) + c;
            }
            ++i;
        }
        return out;
    }

    public static String formatTitle(String title) {
        String line = ".oOo.__________________________________________________.oOo.";
        int pivot = line.length() / 2;
        String center = ".[ \u00a7e" + title + "\u00a76" + " ].";
        String out = "\u00a76" + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = String.valueOf(out) + center + line.substring(pivot + center.length() / 2);
        return out;
    }

    public static String formatCommand(String requirement, String command, String subCommand, String help) {
        String out = "  ";
        if (requirement.length() > 0) {
            out = String.valueOf(out) + "\u00a7c" + requirement + ": ";
        }
        out = String.valueOf(out) + "\u00a73" + command;
        if (subCommand.length() > 0) {
            out = String.valueOf(out) + " \u00a7b" + subCommand;
        }
        if (help.length() > 0) {
            out = String.valueOf(out) + " \u00a77 : " + help;
        }
        return out;
    }

    public static void main(String[] args) {
        String[] players = new String[]{"dude", "bowie", "blarg", "sonbitch", "songoku", "pacman", "link", "stacker", "hacker", "newb"};
        for (String line : ChatTools.listArr(players)) {
            System.out.println(line);
        }
        String testLine = "Loren Ipsum blarg voila tssssssh, boom wakka wakka \u00a7apacman on a boat bitch. From the boat union. Beata lingiushtically \u00a71nootchie lolk erness.";
        for (String line : ChatTools.color(testLine)) {
            System.out.println(line);
        }
    }
}

