/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.TownySettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.InvalidNameException;

public class NameValidation {
    private static Pattern namePattern = null;

    public static String checkAndFilterName(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        if (NameValidation.isBlacklistName(out)) {
            throw new InvalidNameException(String.valueOf(out) + " is an invalid name.");
        }
        return out;
    }

    public static String checkAndFilterPlayerName(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        if (!NameValidation.isValidName(out)) {
            throw new InvalidNameException(String.valueOf(out) + " is an invalid name.");
        }
        return out;
    }

    public static String[] checkAndFilterArray(String[] arr) {
        String[] out = arr;
        int count = 0;
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            out[count] = NameValidation.filterName(word);
            ++count;
            ++n2;
        }
        return out;
    }

    public static boolean isBlacklistName(String name) {
        if (name.length() > TownySettings.getMaxNameLength()) {
            return true;
        }
        ArrayList<String> bannedNames = new ArrayList<String>();
        bannedNames.addAll(Arrays.asList("list", "new", "here", "help", "?", "leave", "withdraw", "deposit", "set", "toggle", "mayor", "assistant", "kick", "add", "claim", "unclaim", "title", "outpost"));
        if (bannedNames.contains(name.toLowerCase())) {
            return true;
        }
        return !NameValidation.isValidName(name);
    }

    public static boolean isValidName(String name) {
        try {
            if (namePattern == null) {
                namePattern = Pattern.compile(TownySettings.getNameCheckRegex());
            }
            return namePattern.matcher(name).find();
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String filterName(String input) {
        return input.replaceAll(TownySettings.getNameFilterRegex(), "_").replaceAll(TownySettings.getNameRemoveRegex(), "");
    }
}

