/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileMgmt {
    public static void checkFolders(String[] folders) {
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            File f = new File(folder);
            if (!f.exists() || !f.isDirectory()) {
                f.mkdir();
            }
            ++n2;
        }
    }

    public static void checkFiles(String[] files) throws IOException {
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File f = new File(file);
            if (!f.exists() || !f.isFile()) {
                f.createNewFile();
            }
            ++n2;
        }
    }

    public static String fileSeparator() {
        return System.getProperty("file.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        File file = sourceLocation;
        synchronized (file) {
            if (sourceLocation.isDirectory()) {
                if (!targetLocation.exists()) {
                    targetLocation.mkdir();
                }
                String[] children = sourceLocation.list();
                int i = 0;
                while (i < children.length) {
                    FileMgmt.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                    ++i;
                }
            } else {
                FileOutputStream out = new FileOutputStream(targetLocation);
                try {
                    int len;
                    FileInputStream in = new FileInputStream(sourceLocation);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    System.out.println("Error: Could not access: " + sourceLocation);
                }
                ((OutputStream)out).close();
            }
        }
    }

    public static File CheckYMLExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static File unpackLanguageFile(String filePath, String resource, String defaultRes) {
        File file = new File(filePath);
        if (file.exists() && !filePath.contains(String.valueOf(FileMgmt.fileSeparator()) + defaultRes)) {
            return file;
        }
        try {
            FileMgmt.checkFiles(new String[]{filePath});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            String resString = FileMgmt.convertStreamToString("/" + resource);
            FileMgmt.stringToFile(resString, filePath);
        }
        catch (IOException e) {
            try {
                String resString = FileMgmt.convertStreamToString("/" + defaultRes);
                FileMgmt.stringToFile(resString, filePath);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return file;
    }

    public static String convertStreamToString(String name) throws IOException {
        if (name != null) {
            StringWriter writer;
            block13: {
                writer = new StringWriter();
                InputStream is = FileMgmt.class.getResourceAsStream(name);
                char[] buffer = new char[1024];
                try {
                    try {
                        int n;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Exception ");
                        try {
                            is.close();
                            break block13;
                        }
                        catch (NullPointerException e2) {
                            throw new IOException();
                        }
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (NullPointerException e) {
                        throw new IOException();
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (NullPointerException e) {
                    throw new IOException();
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static String convertFileToString(File file) {
        if (file != null && file.exists() && file.canRead() && !file.isDirectory()) {
            StringWriter writer;
            block16: {
                writer = new StringWriter();
                FileInputStream is = null;
                char[] buffer = new char[1024];
                try {
                    try {
                        int n;
                        is = new FileInputStream(file);
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Exception ");
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static boolean stringToFile(String source, String FileName) {
        if (source != null) {
            try {
                return FileMgmt.stringToFile(source, new File(FileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean stringToFile(String source, File file) throws IOException {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            source.replaceAll("\n", System.getProperty("line.separator"));
            out.write(source);
            out.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Exception ");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(File sourceFile, String targetLocation) throws IOException {
        File file = sourceFile;
        synchronized (file) {
            if (sourceFile.isFile()) {
                File f = new File(String.valueOf(sourceFile.getParent()) + FileMgmt.fileSeparator() + targetLocation);
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
                boolean bl = sourceFile.renameTo(new File(String.valueOf(sourceFile.getParent()) + FileMgmt.fileSeparator() + targetLocation, sourceFile.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(File sourceFolder, File destination) throws IOException {
        File file = sourceFolder;
        synchronized (file) {
            ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destination));
            FileMgmt.recursiveZipDirectory(sourceFolder, output);
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectories(File[] sourceFolders, File destination) throws IOException {
        File[] fileArray = sourceFolders;
        synchronized (sourceFolders) {
            ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destination));
            File[] fileArray2 = sourceFolders;
            int n = sourceFolders.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceFolder = fileArray2[n2];
                FileMgmt.recursiveZipDirectory(sourceFolder, output);
                ++n2;
            }
            output.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveZipDirectory(File sourceFolder, ZipOutputStream zipStream) throws IOException {
        File file = sourceFolder;
        synchronized (file) {
            String[] dirList = sourceFolder.list();
            byte[] readBuffer = new byte[2156];
            int bytesIn = 0;
            int i = 0;
            while (i < dirList.length) {
                File f = new File(sourceFolder, dirList[i]);
                if (f.isDirectory()) {
                    FileMgmt.recursiveZipDirectory(f, zipStream);
                } else {
                    FileInputStream input = new FileInputStream(f);
                    ZipEntry anEntry = new ZipEntry(f.getPath());
                    zipStream.putNextEntry(anEntry);
                    while ((bytesIn = input.read(readBuffer)) != -1) {
                        zipStream.write(readBuffer, 0, bytesIn);
                    }
                    input.close();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(File file) {
        File file2 = file;
        synchronized (file2) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    File[] fileArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        FileMgmt.deleteFile(child);
                        ++n2;
                    }
                }
                if (!((children = file.listFiles()) != null && children.length != 0 || file.delete())) {
                    System.out.println("Error: Could not delete folder: " + file.getPath());
                }
            } else if (file.isFile() && !file.delete()) {
                System.out.println("Error: Could not delete file: " + file.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOldBackups(File backupsDir, long deleteAfter) {
        File file = backupsDir;
        synchronized (file) {
            File[] children;
            TreeSet<Long> deleted = new TreeSet<Long>();
            if (backupsDir.isDirectory() && (children = backupsDir.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    try {
                        long age;
                        String[] tokens;
                        String lastToken;
                        long timeMade;
                        String filename = child.getName();
                        if (child.isFile() && filename.contains(".")) {
                            filename = filename.split("\\.")[0];
                        }
                        if ((timeMade = Long.parseLong(lastToken = (tokens = filename.split(" "))[tokens.length - 1])) >= 0L && (age = System.currentTimeMillis() - timeMade) >= deleteAfter) {
                            FileMgmt.deleteFile(child);
                            deleted.add(age);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            if (deleted.size() > 0) {
                System.out.println(String.format("[Towny] Deleting %d Old Backups (%s).", deleted.size(), deleted.size() > 1 ? String.format("%d-%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()), TimeUnit.MILLISECONDS.toDays((Long)deleted.last())) : String.format("%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deleteUnusedFiles(File residentDir, Set<String> fileNames) {
        File file = residentDir;
        synchronized (file) {
            File[] children;
            int count = 0;
            if (residentDir.isDirectory() && (children = residentDir.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    try {
                        String filename = child.getName();
                        if (child.isFile()) {
                            if (filename.contains(".txt")) {
                                filename = filename.split("\\.txt")[0];
                            }
                            if (!fileNames.contains(filename.toLowerCase())) {
                                FileMgmt.deleteFile(child);
                                ++count;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
                if (count > 0) {
                    System.out.println(String.format("[Towny] Deleted %d old files.", count));
                }
            }
        }
    }
}

