/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.util.KeyValue;
import com.palmergames.util.Sorting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class KeyValueTable<K, V> {
    private List<KeyValue<K, V>> keyValues = new ArrayList<KeyValue<K, V>>();

    public List<KeyValue<K, V>> getKeyValues() {
        return this.keyValues;
    }

    public void setKeyValues(List<KeyValue<K, V>> keyValues) {
        this.keyValues = keyValues;
    }

    public KeyValueTable() {
    }

    public KeyValueTable(Hashtable<K, V> table) {
        this(new ArrayList<K>(table.keySet()), new ArrayList<V>(table.values()));
    }

    public KeyValueTable(List<K> keys, List<V> values) {
        int i = 0;
        while (i < keys.size()) {
            this.keyValues.add(new KeyValue<K, V>(keys.get(i), values.get(i)));
            ++i;
        }
    }

    public void put(K key, V value) {
        this.keyValues.add(new KeyValue<K, V>(key, value));
    }

    public void add(KeyValue<K, V> keyValue) {
        this.keyValues.add(keyValue);
    }

    public void sortByKey() {
        Collections.sort(this.keyValues, new Sorting.KeySort());
    }

    public void sortByValue() {
        Collections.sort(this.keyValues, new Sorting.ValueSort());
    }

    public void revese() {
        Collections.reverse(this.keyValues);
    }
}

