/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.util.ArrayList;
import java.util.List;

public class TimeMgmt {
    public static final long[][] defaultCountdownDelays = new long[][]{{10L, 1L}, {30L, 5L}, {60L, 10L}, {300L, 60L}, {1800L, 300L}, {3600L, 600L}, {86400L, 3600L}, {Integer.MAX_VALUE, 86400L}};

    public static List<Long> getCountdownDelays(int start) {
        return TimeMgmt.getCountdownDelays(start, defaultCountdownDelays);
    }

    public static List<Long> getCountdownDelays(int start, long[][] delays) {
        ArrayList<Long> out = new ArrayList<Long>();
        int d = 0;
        while (d < delays.length) {
            if (delays[d].length != 2) {
                return null;
            }
            ++d;
        }
        Integer lastDelayIndex = null;
        long nextWarningAt = Integer.MAX_VALUE;
        long t = start;
        while (t > 0L) {
            int d2 = 0;
            while (d2 < delays.length) {
                if (t <= delays[d2][0] && (lastDelayIndex == null || t <= nextWarningAt || d2 < lastDelayIndex)) {
                    lastDelayIndex = d2;
                    nextWarningAt = t - delays[d2][1];
                    out.add(new Long(t));
                    break;
                }
                ++d2;
            }
            --t;
        }
        return out;
    }

    public static String formatCountdownTime(long l) {
        String out = "";
        if (l >= 3600L) {
            int h = (int)Math.floor(l / 3600L);
            out = String.valueOf(h) + " hours";
            l -= (long)(h * 3600);
        }
        if (l >= 60L) {
            int m = (int)Math.floor(l / 60L);
            out = String.valueOf(out) + (out.length() > 0 ? ", " : "") + m + " minutes";
            l -= (long)(m * 60);
        }
        if (out.length() == 0 || l > 0L) {
            out = String.valueOf(out) + (out.length() > 0 ? ", " : "") + l + " seconds";
        }
        return out;
    }

    public static void main(String[] args) {
        for (Long l : TimeMgmt.getCountdownDelays(36000000, defaultCountdownDelays)) {
            System.out.println(l + " " + TimeMgmt.formatCountdownTime(l));
        }
    }
}

