/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat;

import com.palmergames.bukkit.TownyChat.TownyChatReplacerCallable;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.listener.LocalTownyChatEvent;
import com.palmergames.bukkit.TownyChat.util.StringReplaceManager;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.regex.Pattern;

public class TownyChatFormatter {
    private static StringReplaceManager<LocalTownyChatEvent> replacer = new StringReplaceManager();

    public static String getChatFormat(LocalTownyChatEvent localTownyChatEvent) {
        return replacer.replaceAll(localTownyChatEvent.getFormat(), localTownyChatEvent).replace("{modplayername}", "%1$s").replace("{msg}", "%2$s");
    }

    public static String formatTownyTag(Resident resident, Boolean bl, Boolean bl2) {
        try {
            if (resident.hasTown()) {
                Town town = resident.getTown();
                String string = town.getTag();
                Nation nation = null;
                String string2 = null;
                if (resident.hasNation()) {
                    nation = town.getNation();
                    string2 = nation.getTag();
                }
                String string3 = "";
                String string4 = "";
                if (bl2.booleanValue()) {
                    string2 = "";
                    string = "";
                }
                if (string != null && !string.isEmpty()) {
                    string4 = string;
                } else if (bl.booleanValue() || bl2.booleanValue()) {
                    string4 = town.getName();
                }
                if (string2 != null && !string2.isEmpty()) {
                    string3 = string2;
                } else if (resident.hasNation() && (bl.booleanValue() || bl2.booleanValue())) {
                    string3 = nation.getName();
                }
                if (!string4.isEmpty() && !string3.isEmpty()) {
                    return String.format(ChatSettings.getBothTags(), string3, string4);
                }
                if (!string3.isEmpty()) {
                    return String.format(ChatSettings.getNationTag(), string3);
                }
                if (!string4.isEmpty()) {
                    return String.format(ChatSettings.getTownTag(), string4);
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return "";
    }

    public static String formatTownTag(Resident resident, Boolean bl, Boolean bl2) {
        try {
            if (resident.hasTown()) {
                if (bl2.booleanValue()) {
                    return String.format(ChatSettings.getTownTag(), resident.getTown().getName());
                }
                if (resident.getTown().hasTag()) {
                    return String.format(ChatSettings.getTownTag(), resident.getTown().getTag());
                }
                if (bl.booleanValue()) {
                    return String.format(ChatSettings.getTownTag(), resident.getTown().getName());
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return "";
    }

    public static String formatNationTag(Resident resident, Boolean bl, Boolean bl2) {
        try {
            if (resident.hasNation()) {
                if (bl2.booleanValue()) {
                    return String.format(ChatSettings.getNationTag(), resident.getTown().getNation().getName());
                }
                if (resident.getTown().getNation().hasTag()) {
                    return String.format(ChatSettings.getNationTag(), resident.getTown().getNation().getTag());
                }
                if (bl.booleanValue()) {
                    return String.format(ChatSettings.getNationTag(), resident.getTown().getNation().getName());
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return "";
    }

    static {
        replacer.registerFormatReplacement(Pattern.quote("{worldname}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return String.format(ChatSettings.getWorldTag(), localTownyChatEvent.getEvent().getPlayer().getWorld().getName());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{town}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getResident().hasTown() ? localTownyChatEvent.getResident().getTown().getName() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townformatted}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatTownTag(localTownyChatEvent.getResident(), false, true);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{towntag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatTownTag(localTownyChatEvent.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{towntagoverride}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatTownTag(localTownyChatEvent.getResident(), true, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nation}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getResident().hasNation() ? localTownyChatEvent.getResident().getTown().getNation().getName() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nationformatted}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatNationTag(localTownyChatEvent.getResident(), false, true);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nationtag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatNationTag(localTownyChatEvent.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nationtagoverride}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatNationTag(localTownyChatEvent.getResident(), true, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townytag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatTownyTag(localTownyChatEvent.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townyformatted}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatTownyTag(localTownyChatEvent.getResident(), false, true);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townytagoverride}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatTownyTag(localTownyChatEvent.getResident(), true, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{title}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getResident().hasTitle() ? localTownyChatEvent.getResident().getTitle() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{surname}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getResident().hasSurname() ? localTownyChatEvent.getResident().getSurname() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townynameprefix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyFormatter.getNamePrefix((Resident)localTownyChatEvent.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townynamepostfix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyFormatter.getNamePostfix((Resident)localTownyChatEvent.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townyprefix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getResident().hasTitle() ? localTownyChatEvent.getResident().getTitle() : TownyFormatter.getNamePrefix((Resident)localTownyChatEvent.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townypostfix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getResident().hasSurname() ? localTownyChatEvent.getResident().getSurname() : TownyFormatter.getNamePostfix((Resident)localTownyChatEvent.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townycolor}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getResident().isMayor() ? (localTownyChatEvent.getResident().isKing() ? ChatSettings.getKingColour() : ChatSettings.getMayorColour()) : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{group}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyUniverse.getPermissionSource().getPlayerGroup(localTownyChatEvent.getEvent().getPlayer());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{permprefix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyUniverse.getPermissionSource().getPrefixSuffix(localTownyChatEvent.getResident(), "prefix");
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{permsuffix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyUniverse.getPermissionSource().getPrefixSuffix(localTownyChatEvent.getResident(), "suffix");
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{playername}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return localTownyChatEvent.getEvent().getPlayer().getName();
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{channelTag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return TownyChatFormatter.formatTownyTag(localTownyChatEvent.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement("&{1}[0-9A-Fa-f]{1}", new TownyChatReplacerCallable(){

            @Override
            public String call(String string, LocalTownyChatEvent localTownyChatEvent) throws Exception {
                return "\u00a7" + string.charAt(1);
            }
        });
    }
}

