/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.channels;

import com.earth2me.essentials.User;
import com.palmergames.bukkit.TownyChat.Chat;
import com.palmergames.bukkit.TownyChat.CraftIRCHandler;
import com.palmergames.bukkit.TownyChat.TownyChatFormatter;
import com.palmergames.bukkit.TownyChat.channels.Channel;
import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.listener.LocalTownyChatEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;

public class StandardChannel
extends Channel {
    private Chat plugin;

    public StandardChannel(Chat chat, String string) {
        super(string);
        this.plugin = chat;
    }

    @Override
    public void chatProcess(PlayerChatEvent playerChatEvent) {
        Object object;
        channelTypes channelTypes2 = channelTypes.valueOf(this.getType().name());
        Player player = playerChatEvent.getPlayer();
        HashSet<Player> hashSet = null;
        Resident resident = null;
        Town town = null;
        Nation nation = null;
        String string = "";
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            nation = resident.getTown().getNation();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        switch (channelTypes2) {
            case TOWN: {
                if (town == null) {
                    playerChatEvent.setCancelled(true);
                    return;
                }
                string = ChatSettings.getRelevantFormatGroup(player).getTOWN();
                hashSet = new HashSet<Player>(this.findRecipients(player, TownyUniverse.getOnlinePlayers((Town)town)));
                break;
            }
            case NATION: {
                if (nation == null) {
                    playerChatEvent.setCancelled(true);
                    return;
                }
                string = ChatSettings.getRelevantFormatGroup(player).getNATION();
                hashSet = new HashSet<Player>(this.findRecipients(player, TownyUniverse.getOnlinePlayers((Nation)nation)));
                break;
            }
            case DEFAULT: {
                string = ChatSettings.getRelevantFormatGroup(player).getDEFAULT();
                hashSet = new HashSet<Player>(this.findRecipients(player, new ArrayList<Player>(Arrays.asList(BukkitTools.getOnlinePlayers()))));
                break;
            }
            case GLOBAL: {
                string = ChatSettings.getRelevantFormatGroup(player).getGLOBAL();
                hashSet = new HashSet<Player>(this.findRecipients(player, new ArrayList<Player>(Arrays.asList(BukkitTools.getOnlinePlayers()))));
                break;
            }
            case PRIVATE: {
                string = ChatSettings.getRelevantFormatGroup(player).getGLOBAL();
                hashSet = new HashSet<Player>(this.findRecipients(player, new ArrayList<Player>(Arrays.asList(BukkitTools.getOnlinePlayers()))));
            }
        }
        playerChatEvent.setFormat(string.replace("{channelTag}", this.getChannelTag()).replace("{msgcolour}", this.getMessageColour()));
        LocalTownyChatEvent localTownyChatEvent = new LocalTownyChatEvent(playerChatEvent, resident);
        playerChatEvent.setFormat(TownyChatFormatter.getChatFormat(localTownyChatEvent));
        playerChatEvent.getRecipients().clear();
        playerChatEvent.getRecipients().addAll(hashSet);
        String string2 = playerChatEvent.getFormat().replace("%1$s", playerChatEvent.getPlayer().getDisplayName()).replace("%2$s", playerChatEvent.getMessage());
        switch (channelTypes2) {
            case TOWN: {
                this.plugin.getLogger().info(ChatTools.stripColour((String)("[Town Msg] " + town.getName() + ": " + string2)));
                break;
            }
            case NATION: {
                this.plugin.getLogger().info(ChatTools.stripColour((String)("[Nation Msg] " + nation.getName() + ": " + string2)));
                break;
            }
            case DEFAULT: {
                break;
            }
            case GLOBAL: 
            case PRIVATE: {
                object = this.plugin.getDynmap();
                if (object == null) break;
                object.postPlayerMessageToWeb(player, playerChatEvent.getMessage());
            }
        }
        object = this.plugin.getIRC();
        if (object != null) {
            ((CraftIRCHandler)((Object)object)).IRCSender(string2, this.getCraftIRCTag());
        }
    }

    private boolean testDistance(Player player, Player player2, double d) {
        if (d == -1.0) {
            return true;
        }
        if (d == 0.0) {
            return player.getWorld().equals(player2.getWorld());
        }
        if (player.getWorld().equals(player2.getWorld())) {
            return player.getLocation().distance(player2.getLocation()) < d;
        }
        return false;
    }

    private Set<Player> findRecipients(Player player, List<Player> list) {
        HashSet<Player> hashSet = new HashSet<Player>();
        Boolean bl = this.plugin.getTowny().isEssentials();
        String string = player.getName();
        for (Player player2 : list) {
            if (this.plugin.getTowny().isPermissions() && (!this.plugin.getTowny().isPermissions() || !TownyUniverse.getPermissionSource().has(player2, this.getPermission())) || !this.testDistance(player, player2, this.getRange()) && !this.plugin.getTowny().hasPlayerMode(player2, "spy")) continue;
            if (bl.booleanValue()) {
                try {
                    User user = this.plugin.getTowny().getEssentials().getUser((Object)player2);
                    if (user.isIgnoredPlayer(string)) {
                        continue;
                    }
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
            }
            hashSet.add(player2);
        }
        return hashSet;
    }
}

