/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.listener;

import com.palmergames.bukkit.TownyChat.Chat;
import com.palmergames.bukkit.TownyChat.TownyChatFormatter;
import com.palmergames.bukkit.TownyChat.channels.Channel;
import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.listener.LocalTownyChatEvent;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.util.StringMgmt;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class TownyChatPlayerListener
implements Listener {
    private Chat plugin;
    private WeakHashMap<Player, Long> SpamTime = new WeakHashMap();
    private WeakHashMap<Player, String> directedChat = new WeakHashMap();

    public TownyChatPlayerListener(Chat chat) {
        this.plugin = chat;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Channel channel;
        Player player = playerCommandPreprocessEvent.getPlayer();
        try {
            TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            return;
        }
        String[] stringArray = playerCommandPreprocessEvent.getMessage().split("\\ ");
        String string = stringArray[0].trim().toLowerCase().replace("/", "");
        String string2 = "";
        if (stringArray.length > 1) {
            string2 = StringMgmt.join((Object[])StringMgmt.remFirstArg((String[])stringArray), (String)" ");
        }
        if ((channel = this.plugin.getChannelsHandler().getChannel(player, string)) != null) {
            playerCommandPreprocessEvent.setMessage(string2);
            if (string2.isEmpty()) {
                if (this.plugin.getTowny().hasPlayerMode(player, channel.getName())) {
                    this.plugin.getTowny().removePlayerMode(player);
                } else {
                    this.plugin.getTowny().setPlayerMode(player, new String[]{channel.getName()}, true);
                }
            } else {
                this.directedChat.put(player, string);
                player.chat(string2);
            }
            playerCommandPreprocessEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerChat(PlayerChatEvent playerChatEvent) {
        Object object;
        Player player = playerChatEvent.getPlayer();
        if (!this.isMuted(player)) {
            if (this.isSpam(player)) {
                playerChatEvent.setCancelled(true);
                return;
            }
            if (this.directedChat.containsKey(player)) {
                object = this.plugin.getChannelsHandler().getChannel(player, this.directedChat.get(player));
                this.directedChat.remove(player);
                if (object != null) {
                    ((Channel)object).chatProcess(playerChatEvent);
                    return;
                }
            }
            for (Channel object2 : this.plugin.getChannelsHandler().getAllChannels().values()) {
                if (!this.plugin.getTowny().hasPlayerMode(player, object2.getName())) continue;
                object2.chatProcess(playerChatEvent);
                return;
            }
            object = this.plugin.getChannelsHandler().getChannel(player, channelTypes.GLOBAL);
            if (object != null) {
                ((Channel)object).chatProcess(playerChatEvent);
                return;
            }
        }
        if (ChatSettings.isModify_chat()) {
            try {
                playerChatEvent.setFormat(ChatSettings.getRelevantFormatGroup(player).getGLOBAL().replace("{channelTag}", "").replace("{msgcolour}", ""));
                object = TownyUniverse.getDataSource().getResident(player.getName());
                LocalTownyChatEvent localTownyChatEvent = new LocalTownyChatEvent(playerChatEvent, (Resident)object);
                playerChatEvent.setFormat(TownyChatFormatter.getChatFormat(localTownyChatEvent));
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
    }

    private boolean isMuted(Player player) {
        if (this.plugin.getTowny().isEssentials()) {
            try {
                if (this.plugin.getTowny().getEssentials().getUser((Object)player).isMuted()) {
                    TownyMessaging.sendErrorMsg((Object)player, (String)"Unable to talk...You are currently muted!");
                    return true;
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    private boolean isSpam(Player player) {
        long l;
        long l2 = l = System.currentTimeMillis();
        if (this.SpamTime.containsKey(player)) {
            l2 = this.SpamTime.get(player);
            this.SpamTime.remove(player);
        } else {
            l2 = (long)((double)l2 - (ChatSettings.getSpam_time() + 1.0) * 1000.0);
        }
        this.SpamTime.put(player, l);
        if ((double)(l - l2) < ChatSettings.getSpam_time() * 1000.0) {
            TownyMessaging.sendErrorMsg((Object)player, (String)"Unable to talk...You are spamming!");
            return true;
        }
        return false;
    }
}

