/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.util;

import com.palmergames.bukkit.TownyChat.util.ReplacerCallable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringReplaceManager<E> {
    private List<Pattern> replacementPatterns = new ArrayList<Pattern>();
    private List<Object> replacements = new ArrayList<Object>();

    public boolean registerFormatReplacement(String string) {
        return this.registerFormatReplacement(string, null);
    }

    public boolean registerFormatReplacement(String string, Object object) {
        Pattern pattern = Pattern.compile(string);
        this.replacementPatterns.add(pattern);
        this.replacements.add(object);
        return true;
    }

    public String replaceAll(String string, E e) {
        String string2 = string;
        for (int i = 0; i < this.replacementPatterns.size(); ++i) {
            Matcher matcher = this.replacementPatterns.get(i).matcher(string2);
            Object object = this.replacements.get(i);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string3 = matcher.group();
                if (object == null) {
                    matcher.appendReplacement(stringBuffer, e.toString());
                    continue;
                }
                if (object instanceof String) {
                    matcher.appendReplacement(stringBuffer, object.toString());
                    continue;
                }
                try {
                    String string4 = ((ReplacerCallable)object).call(string3, e);
                    matcher.appendReplacement(stringBuffer, string4);
                }
                catch (Exception exception) {}
            }
            matcher.appendTail(stringBuffer);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        String string = "\\+{1}[a-zA-Z]+";
        String string2 = "+meh asdf+lo";
        StringReplaceManager<String> stringReplaceManager = new StringReplaceManager<String>();
        stringReplaceManager.registerFormatReplacement(string, "1");
        System.out.println(stringReplaceManager.replaceAll(string2, "2"));
        stringReplaceManager = new StringReplaceManager();
        stringReplaceManager.registerFormatReplacement(string);
        System.out.println(stringReplaceManager.replaceAll(string2, "2"));
        int n = 1000;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            string2.replaceAll(string, "2");
        }
        System.out.println("Runtime: " + (double)(System.currentTimeMillis() - l) / (double)n);
        l = System.currentTimeMillis();
        StringReplaceManager<String> stringReplaceManager2 = new StringReplaceManager<String>();
        stringReplaceManager2.registerFormatReplacement(string);
        for (int i = 0; i < n; ++i) {
            stringReplaceManager2.replaceAll(string2, "2");
        }
        System.out.println("Precompiled: " + (double)(System.currentTimeMillis() - l) / (double)n);
    }
}

